<?php
session_start();

require_once "../controladores/caja.controlador.php";
require_once "../modelos/caja.modelo.php";

class AjaxCaja{
    public $aperturaCaja; 
    
    // crear apertura de la caja
    public function crearAperturaCaja(){
        //obtener la fechaActual, valorApertura, idUsuario, estadoCierre 
        date_default_timezone_set('America/Lima');
        $fechaActual = date('Y-m-d');
        $idUsurio = $_SESSION["id"];
        $valorApertura = $this->aperturaCaja;
        $estadoCierre = "Apertura";
        $datos = [
            "idUsuario" => $idUsurio,
            "fechaCierre" =>  $fechaActual
        ];
        $respuestaCaja = ControladorCaja::ctrValidarAperturaModal($datos);
        if($respuestaCaja){
            echo json_encode(["message" => "apertura ya existe", "status" => 'duplicado', $respuestaCaja]);
        } else {
            
            $datos = [
                "fechaActual" => $fechaActual,
                "valorApertura" => $valorApertura,
                "idUsuario" => $idUsurio,
                "estadoCierre" => $estadoCierre
            ];
            $respuesta = ControladorCaja::ctrCrearAperturaCaja($datos);
            if($respuesta){
                $_SESSION['idCaja'] = $respuesta;
                echo json_encode(["message"=>"Registro exitoso", "status"=>"success", "respuesta"=>$respuesta]);
            }
            
        }
        
        
    }

    // consultar detalle caja
    public function detalleCaja(){
        $idCaja = base64_decode($this->aperturaCaja);
        $respuesta = ControladorCaja::ctrConsultarCaja($idCaja, "Cerrado");
        echo json_encode($respuesta);
    }

}

if(isset($_POST['aperturaCaja'])){
    
    $ajaxCaja = new AjaxCaja();
    $ajaxCaja->aperturaCaja = $_POST['aperturaCaja'];
    $ajaxCaja->crearAperturaCaja();
    
    //var_dump($_SESSION);
   
}
if(isset($_POST['detalleCaja'])){
    $ajaxCaja = new AjaxCaja();
    $ajaxCaja->aperturaCaja = $_POST['detalleCaja'];
    $ajaxCaja->detalleCaja();
}